const progressFill = document.getElementById('progressFill');
const progressText = document.getElementById('progressText');
const status = document.getElementById('status');
const speed = document.getElementById('speed');
const startBtn = document.getElementById('startBtn');
const resetBtn = document.getElementById('resetBtn');

let progress = 0;
let interval = null;

// Simulation de vitesse de téléchargement
function getRandomSpeed() {
    return (Math.random() * 5 + 1).toFixed(2);
}

// Messages de statut selon la progression
function getStatusMessage(progress) {
    if (progress < 25) return 'Initialisation...';
    if (progress < 50) return 'Téléchargement en cours...';
    if (progress < 75) return 'Presque terminé...';
    if (progress < 100) return 'Finalisation...';
    return 'Terminé !';
}

function updateProgress() {
    // Incrément aléatoire pour simuler un téléchargement réel
    const increment = Math.random() * 3 + 1;
    progress = Math.min(progress + increment, 100);

    // Mise à jour de la barre
    progressFill.style.width = `${progress}%`;
    progressText.textContent = `${Math.round(progress)}%`;

    // Mise à jour des informations
    status.textContent = getStatusMessage(progress);
    speed.textContent = progress < 100 ? `${getRandomSpeed()} MB/s` : '0 MB/s';

    // Ajouter la classe active pour l'animation
    progressFill.classList.add('active');

    // Arrêter quand on atteint 100%
    if (progress >= 100) {
        clearInterval(interval);
        interval = null;
        startBtn.disabled = false;
        progressFill.classList.remove('active');
        status.textContent = 'Téléchargement terminé !';

        // Changer la couleur en vert pour indiquer le succès
        progressFill.style.background = 'linear-gradient(90deg, #10b981, #34d399)';
    }
}

function startProgress() {
    if (interval) return; // Déjà en cours

    startBtn.disabled = true;

    // Réinitialiser la couleur si c'était vert
    progressFill.style.background = 'linear-gradient(90deg, var(--primary-color), #6366f1)';

    // Démarrer l'intervalle
    interval = setInterval(updateProgress, 100);
}

function resetProgress() {
    // Arrêter l'intervalle s'il est en cours
    if (interval) {
        clearInterval(interval);
        interval = null;
    }

    // Réinitialiser les valeurs
    progress = 0;
    progressFill.style.width = '0%';
    progressText.textContent = '0%';
    status.textContent = 'Initialisation...';
    speed.textContent = '0 MB/s';
    startBtn.disabled = false;
    progressFill.classList.remove('active');

    // Réinitialiser la couleur
    progressFill.style.background = 'linear-gradient(90deg, var(--primary-color), #6366f1)';
}

// Event listeners
startBtn.addEventListener('click', startProgress);
resetBtn.addEventListener('click', resetProgress);
