// FAB Principal - Scroll to top
const mainFab = document.getElementById('mainFab');

mainFab.addEventListener('click', function() {
    window.scrollTo({
        top: 0,
        behavior: 'smooth'
    });
});

// FAB Menu - Toggle actions
const fabMenu = document.getElementById('fabMenu');
const fabTrigger = document.getElementById('fabTrigger');
const fabActions = document.querySelectorAll('.fab-action');

fabTrigger.addEventListener('click', function(e) {
    e.stopPropagation();
    fabMenu.classList.toggle('active');
});

// Fermer le menu si on clique ailleurs
document.addEventListener('click', function(e) {
    if (!fabMenu.contains(e.target)) {
        fabMenu.classList.remove('active');
    }
});

// Actions des boutons FAB
fabActions.forEach(action => {
    action.addEventListener('click', function() {
        const tooltip = this.getAttribute('data-tooltip');
        console.log(`Action: ${tooltip}`);

        // Fermer le menu après action
        fabMenu.classList.remove('active');

        // Feedback visuel
        this.style.transform = 'scale(0.8)';
        setTimeout(() => {
            this.style.transform = '';
        }, 200);
    });
});
