// Fermer les alertes existantes
const closeButtons = document.querySelectorAll('.alert-close');

closeButtons.forEach(button => {
    button.addEventListener('click', function() {
        const alert = this.closest('.alert');
        alert.classList.add('hiding');
        setTimeout(() => {
            alert.remove();
        }, 300);
    });
});

// Configuration des alertes
const alertConfig = {
    success: {
        icon: 'fa-check-circle',
        title: 'Succès !',
        message: 'L\'opération a été effectuée avec succès.'
    },
    info: {
        icon: 'fa-info-circle',
        title: 'Information',
        message: 'Voici une information importante pour vous.'
    },
    warning: {
        icon: 'fa-exclamation-triangle',
        title: 'Attention',
        message: 'Veuillez prêter attention à ce message.'
    },
    error: {
        icon: 'fa-times-circle',
        title: 'Erreur',
        message: 'Une erreur est survenue lors de l\'opération.'
    }
};

// Fonction pour créer une alerte dynamique
function showAlert(type) {
    const container = document.getElementById('alertContainer');
    const config = alertConfig[type];

    const alert = document.createElement('div');
    alert.className = `alert alert-${type}`;
    alert.innerHTML = `
        <i class="fas ${config.icon} alert-icon"></i>
        <div class="alert-content">
            <h3 class="alert-title">${config.title}</h3>
            <p class="alert-message">${config.message}</p>
        </div>
        <button class="alert-close">
            <i class="fas fa-times"></i>
        </button>
    `;

    // Ajouter au container
    container.appendChild(alert);

    // Ajouter l'événement de fermeture
    const closeBtn = alert.querySelector('.alert-close');
    closeBtn.addEventListener('click', function() {
        alert.classList.add('hiding');
        setTimeout(() => {
            alert.remove();
        }, 300);
    });

    // Auto-fermeture après 5 secondes
    setTimeout(() => {
        if (alert.parentElement) {
            alert.classList.add('hiding');
            setTimeout(() => {
                alert.remove();
            }, 300);
        }
    }, 5000);
}
