const tabLinks = document.querySelectorAll('.tab-link');
const tabPanes = document.querySelectorAll('.tab-pane');
const tabIndicator = document.querySelector('.tab-indicator');

// Initialiser la position de l'indicateur
function updateIndicator(activeLink) {
    const linkRect = activeLink.getBoundingClientRect();
    const headerRect = activeLink.parentElement.getBoundingClientRect();

    tabIndicator.style.width = `${linkRect.width}px`;
    tabIndicator.style.left = `${linkRect.left - headerRect.left}px`;
}

// Initialisation au chargement
const activeLink = document.querySelector('.tab-link.active');
if (activeLink) {
    updateIndicator(activeLink);
}

// Gestion des clics sur les onglets
tabLinks.forEach(link => {
    link.addEventListener('click', function() {
        const tabId = this.getAttribute('data-tab');

        // Retirer la classe active de tous les liens et panes
        tabLinks.forEach(l => l.classList.remove('active'));
        tabPanes.forEach(p => p.classList.remove('active'));

        // Ajouter la classe active au lien et pane correspondants
        this.classList.add('active');
        document.getElementById(tabId).classList.add('active');

        // Mettre à jour la position de l'indicateur
        updateIndicator(this);
    });
});

// Mettre à jour l'indicateur lors du redimensionnement
window.addEventListener('resize', () => {
    const activeLink = document.querySelector('.tab-link.active');
    if (activeLink) {
        updateIndicator(activeLink);
    }
});
