let currentStep = 1;
const totalSteps = 4;

const stepCircles = document.querySelectorAll('.step');
const stepLines = document.querySelectorAll('.step-line');
const stepContents = document.querySelectorAll('.step-content');
const prevBtn = document.getElementById('prev-btn');
const nextBtn = document.getElementById('next-btn');
const successMessage = document.getElementById('success-message');

// Navigation
nextBtn.addEventListener('click', () => {
    if (currentStep < totalSteps) {
        if (validateStep(currentStep)) {
            currentStep++;
            updateStepper();
        }
    } else {
        // Final submission
        if (validateStep(currentStep)) {
            submitForm();
        }
    }
});

prevBtn.addEventListener('click', () => {
    if (currentStep > 1) {
        currentStep--;
        updateStepper();
    }
});

// Update Stepper UI
function updateStepper() {
    // Update step circles
    stepCircles.forEach((step, index) => {
        const stepNumber = index + 1;

        if (stepNumber < currentStep) {
            step.classList.add('completed');
            step.classList.remove('active');
        } else if (stepNumber === currentStep) {
            step.classList.add('active');
            step.classList.remove('completed');
        } else {
            step.classList.remove('active', 'completed');
        }
    });

    // Update step lines
    stepLines.forEach((line, index) => {
        if (index < currentStep - 1) {
            line.classList.add('completed');
        } else {
            line.classList.remove('completed');
        }
    });

    // Update step content
    stepContents.forEach((content, index) => {
        if (index + 1 === currentStep) {
            content.classList.add('active');
        } else {
            content.classList.remove('active');
        }
    });

    // Update summary if on last step
    if (currentStep === totalSteps) {
        updateSummary();
        nextBtn.innerHTML = '<i class="fas fa-check"></i> Valider l\'inscription';
    } else {
        nextBtn.innerHTML = 'Suivant <i class="fas fa-arrow-right"></i>';
    }

    // Update navigation buttons
    prevBtn.disabled = currentStep === 1;
}

// Validation
function validateStep(step) {
    const currentContent = document.querySelector(`.step-content[data-step="${step}"]`);
    const requiredInputs = currentContent.querySelectorAll('[required]');

    let isValid = true;

    requiredInputs.forEach(input => {
        if (!input.value.trim()) {
            isValid = false;
            input.style.borderColor = '#ef4444';
        } else {
            input.style.borderColor = 'var(--border-color)';
        }
    });

    // Special validation for step 3 (password)
    if (step === 3) {
        const password = document.getElementById('password').value;
        const confirmPassword = document.getElementById('confirm-password').value;

        if (password !== confirmPassword) {
            isValid = false;
            document.getElementById('confirm-password').style.borderColor = '#ef4444';
            alert('Les mots de passe ne correspondent pas');
        }

        if (password.length < 8) {
            isValid = false;
            document.getElementById('password').style.borderColor = '#ef4444';
            alert('Le mot de passe doit contenir au moins 8 caractères');
        }
    }

    // Validation for step 4 (terms)
    if (step === 4) {
        const terms = document.getElementById('terms');
        if (!terms.checked) {
            isValid = false;
            alert('Vous devez accepter les conditions générales');
        }
    }

    if (!isValid) {
        alert('Veuillez remplir tous les champs requis');
    }

    return isValid;
}

// Update Summary
function updateSummary() {
    document.getElementById('summary-nom').textContent =
        document.getElementById('nom').value || '-';
    document.getElementById('summary-email').textContent =
        document.getElementById('email').value || '-';
    document.getElementById('summary-telephone').textContent =
        document.getElementById('telephone').value || '-';
    document.getElementById('summary-profession').textContent =
        document.getElementById('profession').value || '-';
    document.getElementById('summary-entreprise').textContent =
        document.getElementById('entreprise').value || 'Non spécifié';

    const experienceSelect = document.getElementById('experience');
    document.getElementById('summary-experience').textContent =
        experienceSelect.options[experienceSelect.selectedIndex]?.text || '-';
}

// Form Submission
function submitForm() {
    // Hide stepper content
    document.querySelectorAll('.step-content').forEach(content => {
        content.style.display = 'none';
    });

    // Hide navigation
    document.querySelector('.stepper-navigation').style.display = 'none';

    // Show success message
    successMessage.classList.add('active');

    // Mark all steps as completed
    stepCircles.forEach(step => {
        step.classList.add('completed');
        step.classList.remove('active');
    });

    stepLines.forEach(line => {
        line.classList.add('completed');
    });

    console.log('Form submitted successfully!');
}

// Real-time input validation styling
document.querySelectorAll('input[required], select[required], textarea[required]').forEach(input => {
    input.addEventListener('blur', function() {
        if (this.value.trim()) {
            this.style.borderColor = 'var(--border-color)';
        }
    });
});

// Initialize
updateStepper();
