// Get all accordions
const accordions = document.querySelectorAll('.accordion');

// Initialize each accordion
accordions.forEach(accordion => {
    const isSingleOpen = accordion.classList.contains('single-open');
    const items = accordion.querySelectorAll('.accordion-item');

    items.forEach(item => {
        const header = item.querySelector('.accordion-header');
        const content = item.querySelector('.accordion-content');

        // Set initial max-height for active items
        if (item.classList.contains('active')) {
            content.style.maxHeight = content.scrollHeight + 'px';
        }

        header.addEventListener('click', () => {
            const isActive = item.classList.contains('active');

            // If single-open mode, close all other items
            if (isSingleOpen && !isActive) {
                items.forEach(otherItem => {
                    if (otherItem !== item && otherItem.classList.contains('active')) {
                        closeItem(otherItem);
                    }
                });
            }

            // Toggle current item
            if (isActive) {
                closeItem(item);
            } else {
                openItem(item);
            }
        });

        // Keyboard accessibility
        header.addEventListener('keydown', (e) => {
            if (e.key === 'Enter' || e.key === ' ') {
                e.preventDefault();
                header.click();
            }
        });
    });
});

// Open accordion item
function openItem(item) {
    const content = item.querySelector('.accordion-content');
    item.classList.add('active');
    content.style.maxHeight = content.scrollHeight + 'px';

    // Add ARIA attributes
    item.querySelector('.accordion-header').setAttribute('aria-expanded', 'true');
}

// Close accordion item
function closeItem(item) {
    const content = item.querySelector('.accordion-content');
    item.classList.remove('active');
    content.style.maxHeight = '0';

    // Add ARIA attributes
    item.querySelector('.accordion-header').setAttribute('aria-expanded', 'false');
}

// Recalculate max-height on window resize (for responsive content)
let resizeTimeout;
window.addEventListener('resize', () => {
    clearTimeout(resizeTimeout);
    resizeTimeout = setTimeout(() => {
        document.querySelectorAll('.accordion-item.active').forEach(item => {
            const content = item.querySelector('.accordion-content');
            content.style.maxHeight = content.scrollHeight + 'px';
        });
    }, 200);
});

// Initialize ARIA attributes
document.querySelectorAll('.accordion-header').forEach((header, index) => {
    const item = header.parentElement;
    const content = item.querySelector('.accordion-content');
    const isActive = item.classList.contains('active');

    // Add IDs and ARIA attributes
    header.setAttribute('id', `accordion-header-${index}`);
    header.setAttribute('aria-expanded', isActive ? 'true' : 'false');
    header.setAttribute('aria-controls', `accordion-content-${index}`);

    content.setAttribute('id', `accordion-content-${index}`);
    content.setAttribute('role', 'region');
    content.setAttribute('aria-labelledby', `accordion-header-${index}`);
});
