// Add click handlers to contact buttons
const contactButtons = document.querySelectorAll('.btn-primary');

contactButtons.forEach(button => {
    button.addEventListener('click', function(e) {
        const card = this.closest('.contact-card');
        const name = card.querySelector('h3').textContent;
        const email = card.querySelector('.fa-envelope').parentElement.textContent.trim();

        // Visual feedback
        this.style.transform = 'scale(0.95)';
        setTimeout(() => {
            this.style.transform = '';
        }, 200);

        // Log action (in a real app, this would open an email client or messaging modal)
        console.log(`Contacting ${name} at ${email}`);

        // Show a simple notification
        showNotification(`Message envoyé à ${name}`);
    });
});

// Add click handlers to add buttons
const addButtons = document.querySelectorAll('.btn-secondary');

addButtons.forEach(button => {
    button.addEventListener('click', function(e) {
        const card = this.closest('.contact-card');
        const name = card.querySelector('h3').textContent;

        // Visual feedback
        this.style.transform = 'scale(0.95)';
        setTimeout(() => {
            this.style.transform = '';
        }, 200);

        // Toggle button state
        if (this.innerHTML.includes('Ajouter')) {
            this.innerHTML = '<i class="fas fa-check"></i> Ajouté';
            this.style.background = '#10b981';
            this.style.color = '#fff';
            this.style.borderColor = '#10b981';
            showNotification(`${name} ajouté à vos contacts`);
        } else {
            this.innerHTML = '<i class="fas fa-user-plus"></i> Ajouter';
            this.style.background = '';
            this.style.color = '';
            this.style.borderColor = '';
            showNotification(`${name} retiré de vos contacts`);
        }
    });
});

// Social links handlers
const socialLinks = document.querySelectorAll('.social-link');

socialLinks.forEach(link => {
    link.addEventListener('click', function(e) {
        e.preventDefault();

        const platform = this.querySelector('i').classList[1].replace('fa-', '');
        const card = this.closest('.contact-card');
        const name = card.querySelector('h3').textContent;

        // Visual feedback
        this.style.transform = 'scale(0.9) translateY(-3px)';
        setTimeout(() => {
            this.style.transform = '';
        }, 200);

        console.log(`Opening ${platform} profile for ${name}`);
        showNotification(`Ouverture du profil ${platform}`);
    });
});

// Simple notification system
function showNotification(message) {
    // Remove existing notification if any
    const existingNotif = document.querySelector('.notification');
    if (existingNotif) {
        existingNotif.remove();
    }

    // Create notification
    const notification = document.createElement('div');
    notification.className = 'notification';
    notification.textContent = message;

    // Style notification
    Object.assign(notification.style, {
        position: 'fixed',
        top: '2rem',
        right: '2rem',
        background: '#4C84FF',
        color: '#fff',
        padding: '1.5rem 2.5rem',
        borderRadius: '0.8rem',
        boxShadow: '0 4px 12px rgba(0, 0, 0, 0.15)',
        fontSize: '1.5rem',
        fontWeight: '500',
        zIndex: '9999',
        animation: 'slideIn 0.3s ease',
        maxWidth: '35rem'
    });

    // Add animation
    const style = document.createElement('style');
    style.textContent = `
        @keyframes slideIn {
            from {
                transform: translateX(40rem);
                opacity: 0;
            }
            to {
                transform: translateX(0);
                opacity: 1;
            }
        }
        @keyframes slideOut {
            from {
                transform: translateX(0);
                opacity: 1;
            }
            to {
                transform: translateX(40rem);
                opacity: 0;
            }
        }
    `;
    document.head.appendChild(style);

    document.body.appendChild(notification);

    // Remove after 3 seconds
    setTimeout(() => {
        notification.style.animation = 'slideOut 0.3s ease';
        setTimeout(() => {
            notification.remove();
        }, 300);
    }, 3000);
}

// Add hover effect for cards
const cards = document.querySelectorAll('.contact-card');

cards.forEach(card => {
    card.addEventListener('mouseenter', function() {
        const statusBadge = this.querySelector('.status-badge');
        if (statusBadge) {
            statusBadge.style.transform = 'scale(1.2)';
        }
    });

    card.addEventListener('mouseleave', function() {
        const statusBadge = this.querySelector('.status-badge');
        if (statusBadge) {
            statusBadge.style.transform = 'scale(1)';
        }
    });
});

// Initialize tooltips for status badges
document.querySelectorAll('.status-badge').forEach(badge => {
    badge.style.transition = 'transform 0.3s ease';

    const status = badge.classList.contains('online') ? 'En ligne' :
                   badge.classList.contains('busy') ? 'Occupé' :
                   badge.classList.contains('away') ? 'Absent' : 'Hors ligne';

    badge.setAttribute('title', status);
});
