// Demo player controls
const playBtn = document.getElementById('play-btn');
const prevBtn = document.getElementById('prev-btn');
const nextBtn = document.getElementById('next-btn');
const muteBtn = document.getElementById('mute-btn');
const volumeRange = document.getElementById('volume-range');
const statusText = document.getElementById('status');

let isPlaying = false;
let isMuted = false;

// Play/Pause toggle
if (playBtn) {
    playBtn.addEventListener('click', () => {
        isPlaying = !isPlaying;

        const icon = playBtn.querySelector('i');
        if (isPlaying) {
            icon.classList.remove('fa-play');
            icon.classList.add('fa-pause');
            statusText.textContent = 'En lecture...';
            playBtn.classList.remove('glass-success');
            playBtn.classList.add('glass-warning');
        } else {
            icon.classList.remove('fa-pause');
            icon.classList.add('fa-play');
            statusText.textContent = 'En pause';
            playBtn.classList.remove('glass-warning');
            playBtn.classList.add('glass-success');
        }
    });
}

// Previous button
if (prevBtn) {
    prevBtn.addEventListener('click', () => {
        statusText.textContent = 'Piste précédente';
        setTimeout(() => {
            if (!isPlaying) {
                statusText.textContent = 'En pause';
            } else {
                statusText.textContent = 'En lecture...';
            }
        }, 1500);
    });
}

// Next button
if (nextBtn) {
    nextBtn.addEventListener('click', () => {
        statusText.textContent = 'Piste suivante';
        setTimeout(() => {
            if (!isPlaying) {
                statusText.textContent = 'En pause';
            } else {
                statusText.textContent = 'En lecture...';
            }
        }, 1500);
    });
}

// Mute toggle
if (muteBtn) {
    muteBtn.addEventListener('click', () => {
        isMuted = !isMuted;

        const icon = muteBtn.querySelector('i');
        if (isMuted) {
            icon.classList.remove('fa-volume-up');
            icon.classList.add('fa-volume-mute');
            volumeRange.value = 0;
        } else {
            icon.classList.remove('fa-volume-mute');
            icon.classList.add('fa-volume-up');
            volumeRange.value = 70;
        }
    });
}

// Volume slider
if (volumeRange) {
    volumeRange.addEventListener('input', (e) => {
        const volume = e.target.value;
        const icon = muteBtn.querySelector('i');

        if (volume == 0) {
            icon.classList.remove('fa-volume-up', 'fa-volume-down');
            icon.classList.add('fa-volume-mute');
            isMuted = true;
        } else if (volume < 50) {
            icon.classList.remove('fa-volume-up', 'fa-volume-mute');
            icon.classList.add('fa-volume-down');
            isMuted = false;
        } else {
            icon.classList.remove('fa-volume-down', 'fa-volume-mute');
            icon.classList.add('fa-volume-up');
            isMuted = false;
        }
    });
}

// Add ripple effect to all glass buttons
const glassButtons = document.querySelectorAll('.glass-btn');

glassButtons.forEach(button => {
    button.addEventListener('click', function(e) {
        // Create ripple element
        const ripple = document.createElement('span');
        ripple.style.position = 'absolute';
        ripple.style.borderRadius = '50%';
        ripple.style.background = 'rgba(255, 255, 255, 0.6)';
        ripple.style.width = '20px';
        ripple.style.height = '20px';
        ripple.style.pointerEvents = 'none';
        ripple.style.animation = 'ripple-effect 0.6s ease-out';

        // Get button dimensions and position
        const rect = this.getBoundingClientRect();
        const size = Math.max(rect.width, rect.height);
        const x = e.clientX - rect.left - size / 2;
        const y = e.clientY - rect.top - size / 2;

        ripple.style.width = ripple.style.height = `${size}px`;
        ripple.style.left = `${x}px`;
        ripple.style.top = `${y}px`;

        this.appendChild(ripple);

        setTimeout(() => {
            ripple.remove();
        }, 600);
    });
});

// Add ripple animation style
const style = document.createElement('style');
style.textContent = `
    @keyframes ripple-effect {
        to {
            transform: scale(4);
            opacity: 0;
        }
    }
`;
document.head.appendChild(style);

// Button group active state
const buttonGroups = document.querySelectorAll('.glass-button-group');

buttonGroups.forEach(group => {
    const buttons = group.querySelectorAll('.glass-btn');

    buttons.forEach(button => {
        button.addEventListener('click', function() {
            // Remove active from all buttons in group
            buttons.forEach(btn => {
                btn.style.background = '';
                btn.style.borderColor = '';
            });

            // Add active to clicked button
            if (this.classList.contains('glass-primary')) {
                this.style.background = 'rgba(76, 132, 255, 0.4)';
                this.style.borderColor = 'rgba(76, 132, 255, 0.6)';
            } else if (this.classList.contains('glass-success')) {
                this.style.background = 'rgba(16, 185, 129, 0.4)';
                this.style.borderColor = 'rgba(16, 185, 129, 0.6)';
            } else {
                this.style.background = 'rgba(255, 255, 255, 0.3)';
                this.style.borderColor = 'rgba(255, 255, 255, 0.5)';
            }
        });
    });
});

// Log button clicks for demo
document.querySelectorAll('.glass-btn').forEach(btn => {
    if (!btn.id) {
        btn.addEventListener('click', function() {
            const text = this.textContent.trim();
            if (text && text.length > 0 && text.length < 50) {
                console.log(`Clicked: ${text}`);
            }
        });
    }
});
