// Sélecteur de statut interactif
const changeStatusBtn = document.getElementById('changeStatusBtn');
const statusDropdown = document.getElementById('statusDropdown');
const currentStatusBadge = document.getElementById('currentStatusBadge');
const currentStatusText = document.getElementById('currentStatusText');
const statusOptions = document.querySelectorAll('.status-option');

// État actuel
let currentStatus = 'online';

// Map des textes de statut
const statusTexts = {
    online: 'En ligne',
    offline: 'Hors ligne',
    busy: 'Occupé',
    away: 'Absent',
    dnd: 'Ne pas déranger'
};

// Toggle du dropdown
changeStatusBtn.addEventListener('click', () => {
    statusDropdown.classList.toggle('active');
});

// Fermer le dropdown si on clique en dehors
document.addEventListener('click', (e) => {
    if (!e.target.closest('.status-selector-demo')) {
        statusDropdown.classList.remove('active');
    }
});

// Gestion du changement de statut
statusOptions.forEach(option => {
    option.addEventListener('click', () => {
        const newStatus = option.dataset.status;

        // Ne rien faire si c'est le même statut
        if (newStatus === currentStatus) {
            statusDropdown.classList.remove('active');
            return;
        }

        // Mettre à jour l'état
        currentStatus = newStatus;

        // Retirer l'ancienne classe et ajouter la nouvelle
        currentStatusBadge.className = `status-badge ${newStatus} pulse`;

        // Mettre à jour le texte
        currentStatusText.textContent = statusTexts[newStatus];

        // Mettre à jour les options actives
        statusOptions.forEach(opt => {
            opt.classList.remove('active');
        });
        option.classList.add('active');

        // Fermer le dropdown
        statusDropdown.classList.remove('active');

        // Animation de feedback
        currentStatusBadge.style.transform = 'scale(1.3)';
        setTimeout(() => {
            currentStatusBadge.style.transform = 'scale(1)';
        }, 300);
    });
});

// Marquer l'option initiale comme active
document.querySelector('.status-option[data-status="online"]').classList.add('active');

// Animation d'entrée progressive pour les cartes utilisateur
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach((entry, index) => {
        if (entry.isIntersecting) {
            setTimeout(() => {
                entry.target.style.opacity = '1';
                entry.target.style.transform = 'translateY(0)';
            }, index * 100);
            observer.unobserve(entry.target);
        }
    });
}, observerOptions);

// Appliquer l'animation aux cartes utilisateur
document.querySelectorAll('.user-card').forEach(card => {
    card.style.opacity = '0';
    card.style.transform = 'translateY(2rem)';
    card.style.transition = 'all 0.5s ease';
    observer.observe(card);
});

// Appliquer l'animation aux éléments de liste
document.querySelectorAll('.user-list-item').forEach((item, index) => {
    item.style.opacity = '0';
    item.style.transform = 'translateX(-2rem)';
    item.style.transition = 'all 0.5s ease';

    setTimeout(() => {
        item.style.opacity = '1';
        item.style.transform = 'translateX(0)';
    }, index * 100);
});

// Animation au survol des status badges
document.querySelectorAll('.status-item').forEach(item => {
    item.addEventListener('mouseenter', () => {
        const badge = item.querySelector('.status-badge');
        badge.style.transform = 'scale(1.2) rotate(360deg)';
        badge.style.transition = 'transform 0.5s ease';
    });

    item.addEventListener('mouseleave', () => {
        const badge = item.querySelector('.status-badge');
        badge.style.transform = 'scale(1) rotate(0deg)';
    });
});

// Simulation de changements de statut aléatoires pour la démo
const userListItems = document.querySelectorAll('.user-list-item');
const statusTypes = ['online', 'offline', 'busy', 'away', 'dnd'];

function randomStatusChange() {
    const randomItem = userListItems[Math.floor(Math.random() * userListItems.length)];
    const statusBadge = randomItem.querySelector('.status-badge');
    const statusIndicator = randomItem.querySelector('.status-indicator');

    const currentClasses = Array.from(statusBadge.classList).filter(c => statusTypes.includes(c));
    const currentStatus = currentClasses[0] || 'offline';

    // Choisir un nouveau statut différent
    const availableStatuses = statusTypes.filter(s => s !== currentStatus);
    const newStatus = availableStatuses[Math.floor(Math.random() * availableStatuses.length)];

    // Animation de transition
    statusBadge.style.transform = 'scale(0)';

    setTimeout(() => {
        statusBadge.classList.remove(...statusTypes);
        statusBadge.classList.add(newStatus);

        statusIndicator.classList.remove(...statusTypes);
        statusIndicator.classList.add(newStatus);

        statusBadge.style.transform = 'scale(1)';
    }, 200);
}

// Changer un statut toutes les 5 secondes (pour la démo)
setInterval(randomStatusChange, 5000);

console.log('Indicateurs de statut utilisateur initialisés !');