// Sélectionner toutes les cartes flip
const flipCards = document.querySelectorAll('.flip-card');

// Ajouter un événement de clic sur chaque carte
flipCards.forEach(card => {
    // Gestion du clic sur la carte
    card.addEventListener('click', (e) => {
        // Ne pas retourner si on clique sur un bouton d'action spécifique
        if (e.target.closest('.add-cart-btn')) {
            return;
        }

        // Toggle la classe flipped
        card.classList.toggle('flipped');
    });

    // Gestion des boutons flip
    const flipButtons = card.querySelectorAll('.flip-btn');
    flipButtons.forEach(btn => {
        btn.addEventListener('click', (e) => {
            e.stopPropagation(); // Empêcher le clic de se propager à la carte
            card.classList.toggle('flipped');
        });
    });

    // Gestion du bouton "Ajouter au panier"
    const addCartBtn = card.querySelector('.add-cart-btn');
    if (addCartBtn) {
        addCartBtn.addEventListener('click', (e) => {
            e.stopPropagation(); // Empêcher le retournement de la carte

            // Animation du bouton
            const originalText = addCartBtn.innerHTML;
            addCartBtn.innerHTML = '<i class="fas fa-check"></i> Ajouté !';
            addCartBtn.style.background = 'linear-gradient(135deg, #48bb78 0%, #38a169 100%)';

            // Feedback visuel sur la carte
            const cardInner = card.querySelector('.flip-card-inner');
            cardInner.style.transform = 'scale(1.05)';

            setTimeout(() => {
                cardInner.style.transform = '';
            }, 200);

            // Restaurer le bouton après 2 secondes
            setTimeout(() => {
                addCartBtn.innerHTML = originalText;
                addCartBtn.style.background = '';
            }, 2000);

            // Log pour la démo
            const productName = card.querySelector('.flip-card-front h3').textContent;
            console.log(`Produit ajouté au panier: ${productName}`);
        });
    }
});

// Animation au scroll
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -100px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.style.opacity = '1';
            entry.target.style.transform = 'translateY(0)';
            observer.unobserve(entry.target);
        }
    });
}, observerOptions);

// Observer les sections
document.querySelectorAll('.demo-section').forEach((section, index) => {
    section.style.opacity = '0';
    section.style.transform = 'translateY(3rem)';
    section.style.transition = 'all 0.6s ease';
    setTimeout(() => {
        observer.observe(section);
    }, index * 100);
});

// Gestion du clavier (Escape pour retourner les cartes)
document.addEventListener('keydown', (e) => {
    if (e.key === 'Escape') {
        flipCards.forEach(card => {
            card.classList.remove('flipped');
        });
    }
});

// Effet sonore au flip (optionnel - désactivé par défaut)
// Pour activer, décommenter et ajouter un fichier audio
/*
const flipSound = new Audio('flip-sound.mp3');
flipCards.forEach(card => {
    card.addEventListener('click', () => {
        flipSound.currentTime = 0;
        flipSound.play().catch(() => {}); // Ignorer les erreurs si l'audio n'est pas chargé
    });
});
*/

// Double-clic pour retourner rapidement
flipCards.forEach(card => {
    let lastClick = 0;
    card.addEventListener('click', (e) => {
        const now = Date.now();
        if (now - lastClick < 300) {
            // Double-clic détecté
            card.classList.toggle('flipped');
        }
        lastClick = now;
    });
});

// Statistiques de flip (pour le développeur)
let flipStats = {
    totalFlips: 0,
    cardsFlipped: new Set()
};

flipCards.forEach(card => {
    const cardId = card.dataset.card;
    card.addEventListener('click', () => {
        if (card.classList.contains('flipped')) {
            flipStats.totalFlips++;
            flipStats.cardsFlipped.add(cardId);
            console.log(`Stats: ${flipStats.totalFlips} flips totaux, ${flipStats.cardsFlipped.size} cartes différentes`);
        }
    });
});

// Auto-flip demo (désactivé par défaut)
// Pour activer une démo automatique au chargement de la page
/*
setTimeout(() => {
    flipCards[0].classList.add('flipped');
    setTimeout(() => {
        flipCards[0].classList.remove('flipped');
    }, 3000);
}, 1000);
*/

// Gestion du redimensionnement
let resizeTimer;
window.addEventListener('resize', () => {
    clearTimeout(resizeTimer);
    resizeTimer = setTimeout(() => {
        // Réinitialiser les cartes retournées lors du redimensionnement
        // (optionnel - peut éviter des problèmes de layout)
        // flipCards.forEach(card => card.classList.remove('flipped'));
    }, 250);
});

// Détection du support 3D
function check3DSupport() {
    const testElement = document.createElement('div');
    testElement.style.transformStyle = 'preserve-3d';

    if (testElement.style.transformStyle === '') {
        console.warn('Les transformations 3D ne sont pas supportées par ce navigateur');
        // Ajouter une classe fallback au body
        document.body.classList.add('no-3d-support');
    }
}

check3DSupport();

console.log('Card Flip 3D initialisé avec succès!');
console.log(`${flipCards.length} cartes interactives prêtes`);
console.log('Appuyez sur Escape pour retourner toutes les cartes');