// Gestion du chat flottant
const floatingBtn = document.getElementById('floatingBtn');
const floatingChat = document.getElementById('floatingChat');
const closeFloatingBtn = document.querySelector('.close-floating-btn');

if (floatingBtn && floatingChat) {
    floatingBtn.addEventListener('click', () => {
        floatingChat.classList.add('active');
        floatingBtn.classList.add('hidden');

        // Focus sur l'input
        const input = floatingChat.querySelector('.message-input');
        setTimeout(() => input.focus(), 300);
    });

    if (closeFloatingBtn) {
        closeFloatingBtn.addEventListener('click', (e) => {
            e.stopPropagation();
            floatingChat.classList.remove('active');
            floatingBtn.classList.remove('hidden');
        });
    }
}

// Gestion de l'envoi de messages
const chatWidgets = document.querySelectorAll('.chat-widget, .floating-chat-widget');

chatWidgets.forEach(widget => {
    const sendBtn = widget.querySelector('.send-btn');
    const messageInput = widget.querySelector('.message-input');
    const chatBody = widget.querySelector('.chat-body');

    if (sendBtn && messageInput) {
        // Envoi au clic
        sendBtn.addEventListener('click', () => {
            sendMessage(messageInput, chatBody);
        });

        // Envoi avec Enter
        messageInput.addEventListener('keypress', (e) => {
            if (e.key === 'Enter') {
                sendMessage(messageInput, chatBody);
            }
        });
    }
});

function sendMessage(input, chatBody) {
    const message = input.value.trim();

    if (message === '') return;

    // Créer le message
    const messageElement = document.createElement('div');
    messageElement.className = 'message sent';

    const now = new Date();
    const time = now.getHours().toString().padStart(2, '0') + ':' +
                 now.getMinutes().toString().padStart(2, '0');

    messageElement.innerHTML = `
        <div class="message-content">
            <p>${escapeHtml(message)}</p>
            <span class="message-time">${time}</span>
        </div>
    `;

    // Retirer l'indicateur de frappe s'il existe
    const typingIndicator = chatBody.querySelector('.typing-indicator');
    if (typingIndicator) {
        typingIndicator.remove();
    }

    // Retirer le message de bienvenue s'il existe
    const welcomeMessage = chatBody.querySelector('.welcome-message');
    const quickActions = chatBody.querySelector('.quick-actions');
    if (welcomeMessage) welcomeMessage.remove();
    if (quickActions) quickActions.remove();

    // Ajouter le message
    chatBody.appendChild(messageElement);

    // Vider l'input
    input.value = '';

    // Scroll vers le bas
    chatBody.scrollTop = chatBody.scrollHeight;

    // Simuler une réponse automatique après 2 secondes
    setTimeout(() => {
        simulateResponse(chatBody);
    }, 2000);
}

function simulateResponse(chatBody) {
    // Ajouter l'indicateur de frappe
    const typingIndicator = document.createElement('div');
    typingIndicator.className = 'typing-indicator';
    typingIndicator.innerHTML = `
        <div class="message-avatar">
            <i class="fas fa-headset"></i>
        </div>
        <div class="typing-dots">
            <span></span>
            <span></span>
            <span></span>
        </div>
    `;

    chatBody.appendChild(typingIndicator);
    chatBody.scrollTop = chatBody.scrollHeight;

    // Réponse automatique après 2 secondes
    setTimeout(() => {
        typingIndicator.remove();

        const responses = [
            "Merci pour votre message ! Un conseiller va vous répondre dans quelques instants.",
            "J'ai bien reçu votre demande. Comment puis-je vous aider davantage ?",
            "Parfait ! Je prends note de votre demande.",
            "D'accord, je comprends. Puis-je avoir plus de détails ?",
            "Entendu ! Je traite votre demande immédiatement."
        ];

        const randomResponse = responses[Math.floor(Math.random() * responses.length)];

        const now = new Date();
        const time = now.getHours().toString().padStart(2, '0') + ':' +
                     now.getMinutes().toString().padStart(2, '0');

        const responseElement = document.createElement('div');
        responseElement.className = 'message received';
        responseElement.innerHTML = `
            <div class="message-avatar">
                <i class="fas fa-headset"></i>
            </div>
            <div class="message-content">
                <p>${randomResponse}</p>
                <span class="message-time">${time}</span>
            </div>
        `;

        chatBody.appendChild(responseElement);
        chatBody.scrollTop = chatBody.scrollHeight;
    }, 2000);
}

function escapeHtml(text) {
    const div = document.createElement('div');
    div.textContent = text;
    return div.innerHTML;
}

// Gestion des actions rapides
const quickActionBtns = document.querySelectorAll('.quick-action-btn');

quickActionBtns.forEach(btn => {
    btn.addEventListener('click', () => {
        const actionText = btn.querySelector('span').textContent;
        const chatBody = btn.closest('.chat-body');
        const messageInput = btn.closest('.floating-chat-widget').querySelector('.message-input');

        // Remplir l'input avec l'action
        messageInput.value = actionText;
        messageInput.focus();

        // Animation du bouton
        btn.style.transform = 'scale(0.95)';
        setTimeout(() => {
            btn.style.transform = '';
        }, 200);
    });
});

// Gestion de la sélection des contacts
const contactItems = document.querySelectorAll('.contact-item');

contactItems.forEach(item => {
    item.addEventListener('click', () => {
        // Retirer la classe active de tous les contacts
        contactItems.forEach(contact => contact.classList.remove('active'));

        // Ajouter la classe active au contact cliqué
        item.classList.add('active');

        // Mettre à jour le header avec les infos du contact
        const contactName = item.querySelector('h4').textContent;
        const statusDot = item.querySelector('.status-dot').className;
        const chatMain = item.closest('.chat-widget').querySelector('.chat-main');
        const headerName = chatMain.querySelector('.contact-info h3');
        const headerStatus = chatMain.querySelector('.status-dot');

        if (headerName) headerName.textContent = contactName;
        if (headerStatus) headerStatus.className = statusDot;

        // Retirer le badge non lu
        const unreadBadge = item.querySelector('.unread-badge');
        if (unreadBadge) {
            unreadBadge.style.transform = 'scale(0)';
            setTimeout(() => unreadBadge.remove(), 300);
        }
    });
});

// Gestion des boutons de minimisation/fermeture
const minimizeBtns = document.querySelectorAll('.minimize-btn');
const closeBtns = document.querySelectorAll('.close-btn');

minimizeBtns.forEach(btn => {
    btn.addEventListener('click', () => {
        const chatWidget = btn.closest('.chat-widget');
        chatWidget.style.transform = 'scale(0.95)';
        chatWidget.style.opacity = '0.5';

        setTimeout(() => {
            chatWidget.style.transform = '';
            chatWidget.style.opacity = '';
        }, 300);
    });
});

closeBtns.forEach(btn => {
    btn.addEventListener('click', () => {
        const chatWidget = btn.closest('.chat-widget');
        chatWidget.style.transform = 'scale(0.9)';
        chatWidget.style.opacity = '0';

        setTimeout(() => {
            chatWidget.style.transform = '';
            chatWidget.style.opacity = '';
        }, 300);
    });
});

// Animation d'entrée des widgets
const observerOptions = {
    threshold: 0.1,
    rootMargin: '0px 0px -50px 0px'
};

const observer = new IntersectionObserver((entries) => {
    entries.forEach(entry => {
        if (entry.isIntersecting) {
            entry.target.style.opacity = '1';
            entry.target.style.transform = 'translateY(0)';
            observer.unobserve(entry.target);
        }
    });
}, observerOptions);

// Appliquer l'animation aux sections
document.querySelectorAll('.demo-section').forEach((section, index) => {
    section.style.opacity = '0';
    section.style.transform = 'translateY(3rem)';
    section.style.transition = 'all 0.6s ease';
    setTimeout(() => {
        observer.observe(section);
    }, index * 100);
});

// Animation des messages au scroll
const chatBodies = document.querySelectorAll('.chat-body');

chatBodies.forEach(chatBody => {
    const messages = chatBody.querySelectorAll('.message');

    messages.forEach((message, index) => {
        message.style.opacity = '0';
        message.style.transform = 'translateY(1rem)';

        setTimeout(() => {
            message.style.transition = 'all 0.4s ease';
            message.style.opacity = '1';
            message.style.transform = 'translateY(0)';
        }, index * 100);
    });
});

// Gestion de la recherche dans les contacts
const searchInputs = document.querySelectorAll('.search-box input');

searchInputs.forEach(searchInput => {
    searchInput.addEventListener('input', (e) => {
        const searchTerm = e.target.value.toLowerCase();
        const contactsList = searchInput.closest('.contacts-sidebar').querySelector('.contacts-list');
        const contacts = contactsList.querySelectorAll('.contact-item');

        contacts.forEach(contact => {
            const name = contact.querySelector('h4').textContent.toLowerCase();
            const message = contact.querySelector('.last-message').textContent.toLowerCase();

            if (name.includes(searchTerm) || message.includes(searchTerm)) {
                contact.style.display = 'flex';
            } else {
                contact.style.display = 'none';
            }
        });
    });
});

// Auto-scroll au dernier message
chatBodies.forEach(chatBody => {
    setTimeout(() => {
        chatBody.scrollTop = chatBody.scrollHeight;
    }, 500);
});

// Notification sonore (désactivé par défaut)
function playNotificationSound() {
    // Créer un son simple avec Web Audio API
    const audioContext = new (window.AudioContext || window.webkitAudioContext)();
    const oscillator = audioContext.createOscillator();
    const gainNode = audioContext.createGain();

    oscillator.connect(gainNode);
    gainNode.connect(audioContext.destination);

    oscillator.frequency.value = 800;
    oscillator.type = 'sine';

    gainNode.gain.setValueAtTime(0.3, audioContext.currentTime);
    gainNode.gain.exponentialRampToValueAtTime(0.01, audioContext.currentTime + 0.1);

    oscillator.start(audioContext.currentTime);
    oscillator.stop(audioContext.currentTime + 0.1);
}

// Stats pour le développeur
console.log('Widget de chat minimaliste initialisé!');
console.log(`${chatWidgets.length} widgets de chat détectés`);
console.log(`${contactItems.length} contacts disponibles`);