// Optionnel : Change la couleur du néon au clic
const button = document.querySelector('.neon-button');
const colors = ['#0ff', '#f0f', '#ff0', '#0f0', '#f00'];
let currentColorIndex = 0;

button.addEventListener('click', function() {
    currentColorIndex = (currentColorIndex + 1) % colors.length;
    const newColor = colors[currentColorIndex];

    document.documentElement.style.setProperty('--neon-color', newColor);
    document.documentElement.style.setProperty('--neon-shadow',
        `0 0 10px ${newColor},
         0 0 20px ${newColor},
         0 0 30px ${newColor},
         0 0 40px ${newColor}`
    );
});
