// ========================================
// Seed I.T - Indicateur de chargement circulaire
// ========================================

(() => {
  'use strict';

  // Fonction pour afficher l'overlay de chargement
  window.toggleOverlay = function() {
    const overlay = document.getElementById('loaderOverlay');

    if (overlay.style.display === 'none') {
      // Afficher l'overlay
      overlay.style.display = 'flex';

      // Cacher automatiquement après 3 secondes (pour la démo)
      setTimeout(() => {
        overlay.style.display = 'none';
      }, 3000);
    } else {
      // Cacher l'overlay
      overlay.style.display = 'none';
    }
  };

  // Fonction utilitaire pour créer un loader programmatiquement
  window.createSeeditLoader = function(options = {}) {
    const {
      size = 'medium', // 'small', 'medium', 'large'
      text = 'Chargement...',
      showText = true,
      ariaLabel = 'Chargement en cours'
    } = options;

    // Créer le conteneur principal
    const loader = document.createElement('div');
    loader.className = `seedit-loader${size !== 'medium' ? ` seedit-loader--${size}` : ''}`;
    loader.setAttribute('role', 'status');
    loader.setAttribute('aria-live', 'polite');
    loader.setAttribute('aria-label', ariaLabel);

    // Créer le SVG spinner
    const svg = document.createElementNS('http://www.w3.org/2000/svg', 'svg');
    svg.classList.add('seedit-loader__spinner');
    svg.setAttribute('viewBox', '0 0 50 50');

    const circle = document.createElementNS('http://www.w3.org/2000/svg', 'circle');
    circle.classList.add('seedit-loader__circle');
    circle.setAttribute('cx', '25');
    circle.setAttribute('cy', '25');
    circle.setAttribute('r', '20');
    circle.setAttribute('fill', 'none');
    circle.setAttribute('stroke-width', '4');

    svg.appendChild(circle);
    loader.appendChild(svg);

    // Ajouter le texte si demandé
    if (showText && text) {
      const textSpan = document.createElement('span');
      textSpan.classList.add('seedit-loader__text');
      textSpan.textContent = text;
      loader.appendChild(textSpan);
    }

    return loader;
  };

  // Fonction utilitaire pour afficher un loader en overlay
  window.showSeeditLoaderOverlay = function(options = {}) {
    const {
      text = 'Chargement...',
      duration = null // durée en ms (null = infini)
    } = options;

    // Créer l'overlay s'il n'existe pas
    let overlay = document.querySelector('.seedit-loader-overlay');

    if (!overlay) {
      overlay = document.createElement('div');
      overlay.classList.add('seedit-loader-overlay');
      document.body.appendChild(overlay);
    }

    // Vider l'overlay et ajouter un nouveau loader
    overlay.innerHTML = '';
    const loader = window.createSeeditLoader({
      size: 'large',
      text: text,
      showText: true
    });
    overlay.appendChild(loader);

    // Afficher l'overlay
    overlay.style.display = 'flex';

    // Cacher automatiquement si une durée est spécifiée
    if (duration) {
      setTimeout(() => {
        window.hideSeeditLoaderOverlay();
      }, duration);
    }
  };

  // Fonction utilitaire pour cacher le loader overlay
  window.hideSeeditLoaderOverlay = function() {
    const overlay = document.querySelector('.seedit-loader-overlay');
    if (overlay) {
      overlay.style.display = 'none';
    }
  };

  // Exemple d'utilisation dans la console :
  // createSeeditLoader({ size: 'large', text: 'Chargement personnalisé' })
  // showSeeditLoaderOverlay({ text: 'Traitement en cours...', duration: 3000 })
  // hideSeeditLoaderOverlay()

})();
