/**
 * Seed I.T - Carte avec Hover Zoom
 *
 * Ce composant est principalement CSS.
 * Le JavaScript est minimal et sert uniquement à ajouter
 * un support clavier pour l'accessibilité.
 */

(() => {
  'use strict';

  // Initialisation au chargement du DOM
  document.addEventListener('DOMContentLoaded', () => {
    initCarteZoom();
  });

  /**
   * Initialise l'accessibilité clavier pour la carte
   */
  function initCarteZoom() {
    const carte = document.querySelector('.seedit-carte-zoom');

    if (!carte) return;

    // Rendre la carte focusable au clavier
    if (!carte.hasAttribute('tabindex')) {
      carte.setAttribute('tabindex', '0');
    }

    // Gérer l'activation au clavier (Enter ou Space)
    carte.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();

        // Trouver le lien principal et le suivre
        const lien = carte.querySelector('.seedit-carte-zoom__link');
        if (lien) {
          lien.click();
        }
      }
    });

    // Optionnel : Log pour confirmer l'initialisation
    console.log('✓ Carte avec hover zoom initialisée');
  }
})();
