/* ========================================
   Seed I.T — Bouton Retour en Haut
   Script JavaScript (vanilla, encapsulé)
   ======================================== */

// Encapsulation dans une IIFE pour éviter la pollution du scope global
(() => {
  // Sélection du bouton dans le DOM
  const scrollTopBtn = document.querySelector('.seedit-scroll-top');

  // Seuil de scroll en pixels pour afficher le bouton
  const SCROLL_THRESHOLD = 300;

  // Variable pour optimiser les performances (throttling)
  let isScrolling = false;

  /**
   * Affiche ou masque le bouton en fonction de la position de scroll
   */
  function toggleButtonVisibility() {
    const scrollY = window.scrollY || window.pageYOffset;

    if (scrollY > SCROLL_THRESHOLD) {
      scrollTopBtn.classList.add('seedit-scroll-top--visible');
    } else {
      scrollTopBtn.classList.remove('seedit-scroll-top--visible');
    }

    isScrolling = false;
  }

  /**
   * Gère l'événement de scroll avec optimisation des performances
   */
  function handleScroll() {
    if (!isScrolling) {
      isScrolling = true;
      requestAnimationFrame(toggleButtonVisibility);
    }
  }

  /**
   * Retourne en haut de la page avec un scroll fluide
   */
  function scrollToTop() {
    window.scrollTo({
      top: 0,
      behavior: 'smooth'
    });
  }

  /**
   * Gère l'activation du bouton au clavier (Enter ou Space)
   */
  function handleKeyPress(event) {
    // Vérifie si la touche pressée est Enter (13) ou Space (32)
    if (event.key === 'Enter' || event.key === ' ') {
      event.preventDefault(); // Empêche le scroll par défaut de Space
      scrollToTop();
    }
  }

  // Initialisation : écouteurs d'événements
  function init() {
    // Vérification de l'existence du bouton
    if (!scrollTopBtn) {
      return;
    }

    // Écoute du scroll sur la fenêtre
    window.addEventListener('scroll', handleScroll, { passive: true });

    // Écoute du clic sur le bouton
    scrollTopBtn.addEventListener('click', scrollToTop);

    // Écoute des touches clavier pour l'accessibilité
    scrollTopBtn.addEventListener('keydown', handleKeyPress);

    // Vérification initiale de la position de scroll
    toggleButtonVisibility();
  }

  // Démarrage du composant au chargement du DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }
})();
