/* ===================================
   Seed I.T - Input avec Clear Button Animé
   Gestion des interactions
   =================================== */

(() => {
  'use strict';

  /**
   * Initialise un input avec son bouton clear
   * @param {HTMLElement} container - Conteneur .seedit-clear-input
   */
  function initClearInput(container) {
    const input = container.querySelector('.seedit-clear-input__field');
    const clearBtn = container.querySelector('.seedit-clear-input__btn');

    if (!input || !clearBtn) return;

    /**
     * Met à jour la visibilité du bouton clear selon la valeur de l'input
     */
    function updateClearButtonVisibility() {
      if (input.value.trim().length > 0) {
        clearBtn.classList.add('seedit-clear-input__btn--visible');
      } else {
        clearBtn.classList.remove('seedit-clear-input__btn--visible');
      }
    }

    /**
     * Efface le contenu de l'input et remet le focus
     */
    function clearInput() {
      // Vérifier si le composant est désactivé
      if (input.disabled || container.classList.contains('seedit-clear-input--disabled')) {
        return;
      }

      input.value = '';
      updateClearButtonVisibility();
      input.focus();

      // Déclencher un événement input pour permettre l'écoute externe
      input.dispatchEvent(new Event('input', { bubbles: true }));
    }

    // Écouter les changements de valeur dans l'input
    input.addEventListener('input', updateClearButtonVisibility);

    // Écouter le clic sur le bouton clear
    clearBtn.addEventListener('click', clearInput);

    // Support clavier : Escape pour effacer
    input.addEventListener('keydown', (e) => {
      if (e.key === 'Escape' && input.value.length > 0) {
        e.preventDefault();
        clearInput();
      }
    });

    // Initialiser l'état au chargement (pour les inputs pré-remplis)
    updateClearButtonVisibility();
  }

  /**
   * Initialisation de tous les inputs avec clear button au chargement du DOM
   */
  function init() {
    const clearInputs = document.querySelectorAll('.seedit-clear-input');

    clearInputs.forEach(input => {
      initClearInput(input);
    });
  }

  // Lancement automatique au chargement du DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  // Exposer la fonction d'initialisation pour usage externe si nécessaire
  window.SeeditClearInput = {
    init: initClearInput
  };

})();
