/* ===================================
   Seed I.T - Champ Mot de Passe avec Affichage
   Gestion des interactions
   =================================== */

(() => {
  'use strict';

  /**
   * Initialise un champ de mot de passe
   * @param {HTMLElement} container - Conteneur .seedit-password-input
   */
  function initPasswordInput(container) {
    const input = container.querySelector('.seedit-password-input__field');
    const toggleBtn = container.querySelector('.seedit-password-input__toggle');

    if (!input || !toggleBtn) return;

    /**
     * Toggle entre password et text
     */
    function togglePasswordVisibility() {
      // Vérifier si le composant est désactivé
      if (input.disabled || container.classList.contains('seedit-password-input--disabled')) {
        return;
      }

      const isPassword = input.type === 'password';

      // Changer le type d'input
      input.type = isPassword ? 'text' : 'password';

      // Mettre à jour la classe du conteneur pour l'animation des icônes
      container.classList.toggle('seedit-password-input--visible', !isPassword);

      // Mettre à jour l'aria-label du bouton
      toggleBtn.setAttribute(
        'aria-label',
        isPassword ? 'Masquer le mot de passe' : 'Afficher le mot de passe'
      );

      // Remettre le focus sur l'input
      input.focus();

      // Déclencher un événement personnalisé
      container.dispatchEvent(new CustomEvent('password-visibility-toggle', {
        bubbles: true,
        detail: {
          visible: !isPassword
        }
      }));
    }

    // Écouter le clic sur le bouton toggle
    toggleBtn.addEventListener('click', togglePasswordVisibility);

    // Support clavier : Enter sur le bouton toggle
    toggleBtn.addEventListener('keydown', (e) => {
      if (e.key === 'Enter') {
        e.preventDefault();
        togglePasswordVisibility();
      }
    });
  }

  /**
   * Initialisation de tous les champs password au chargement du DOM
   */
  function init() {
    const passwordInputs = document.querySelectorAll('.seedit-password-input');

    passwordInputs.forEach(input => {
      initPasswordInput(input);
    });
  }

  // Lancement automatique au chargement du DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

  // Exposer la fonction d'initialisation pour usage externe si nécessaire
  window.SeeditPasswordInput = {
    init: initPasswordInput
  };

})();
