/* ============================================
   SEED I.T - Carte avec effet de déchirure papier
   Script JavaScript (optionnel)
   ============================================ */

(() => {
  'use strict';

  // Ce composant fonctionne entièrement en CSS
  // Le JavaScript n'est pas nécessaire pour le fonctionnement de base

  // Toutefois, on peut ajouter des améliorations progressives :

  // 1. Rendre les cartes focusables au clavier pour l'accessibilité
  document.addEventListener('DOMContentLoaded', () => {
    const cards = document.querySelectorAll('.seedit-torn-card');

    cards.forEach((card) => {
      // Rendre la carte focusable si elle ne l'est pas déjà
      if (!card.hasAttribute('tabindex')) {
        card.setAttribute('tabindex', '0');
      }

      // Ajouter un rôle pour l'accessibilité
      if (!card.hasAttribute('role')) {
        card.setAttribute('role', 'article');
      }

      // Gestion optionnelle du clic/Enter sur la carte
      const handleActivation = (e) => {
        if (e.type === 'click' || (e.type === 'keydown' && (e.key === 'Enter' || e.key === ' '))) {
          e.preventDefault();

          // Animation de "pulse" au clic
          card.style.transform = 'scale(0.98)';
          setTimeout(() => {
            card.style.transform = '';
          }, 150);

          // Vous pouvez ajouter ici une action personnalisée
          // Par exemple : ouvrir un modal, naviguer vers une page, etc.
          console.log('Carte activée :', card.querySelector('.seedit-torn-card__title')?.textContent);
        }
      };

      card.addEventListener('click', handleActivation);
      card.addEventListener('keydown', handleActivation);
    });
  });

  // 2. Animation d'apparition au scroll (intersection observer)
  if ('IntersectionObserver' in window) {
    const observer = new IntersectionObserver(
      (entries) => {
        entries.forEach((entry) => {
          if (entry.isIntersecting) {
            entry.target.style.opacity = '1';
            entry.target.style.transform = 'translateY(0)';
          }
        });
      },
      {
        threshold: 0.1,
        rootMargin: '0px 0px -50px 0px'
      }
    );

    document.addEventListener('DOMContentLoaded', () => {
      const cards = document.querySelectorAll('.seedit-torn-card');
      cards.forEach((card) => {
        // Initialiser l'état avant l'observation (optionnel)
        // card.style.opacity = '0';
        // card.style.transform = 'translateY(20px)';
        observer.observe(card);
      });
    });
  }

  console.log('Seed I.T - Carte avec effet de déchirure papier chargée ✓');
})();
