// ====================================
// Progress Bar avec Gradient Animé - Seed I.T
// ====================================

(function() {
  'use strict';

  // Éléments du DOM
  const progress1 = document.getElementById('progress1');
  const progress1Value = document.getElementById('progress1Value');
  const increaseBtn = document.getElementById('increaseBtn');
  const decreaseBtn = document.getElementById('decreaseBtn');
  const resetBtn = document.getElementById('resetBtn');

  // État de la progression
  let currentProgress = 45;

  // ====================================
  // Fonction : Mettre à jour la progress bar
  // ====================================
  function updateProgress(value) {
    // Limiter entre 0 et 100
    currentProgress = Math.max(0, Math.min(100, value));

    // Mettre à jour l'affichage
    progress1.style.width = `${currentProgress}%`;
    progress1Value.textContent = `${currentProgress}%`;

    // Mettre à jour l'attribut ARIA
    progress1.parentElement.setAttribute('aria-valuenow', currentProgress);

    // Ajouter une classe pour animation de completion
    if (currentProgress === 100) {
      progress1.parentElement.classList.add('seedit-progress-bar--complete');
    } else {
      progress1.parentElement.classList.remove('seedit-progress-bar--complete');
    }
  }

  // ====================================
  // Gestionnaires d'événements
  // ====================================

  // Augmenter la progression de 10%
  increaseBtn.addEventListener('click', () => {
    updateProgress(currentProgress + 10);
  });

  // Diminuer la progression de 10%
  decreaseBtn.addEventListener('click', () => {
    updateProgress(currentProgress - 10);
  });

  // Réinitialiser à 45%
  resetBtn.addEventListener('click', () => {
    updateProgress(45);
  });

  // Accessibilité : gestion clavier pour les boutons
  [increaseBtn, decreaseBtn, resetBtn].forEach(btn => {
    btn.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        btn.click();
      }
    });
  });

  // ====================================
  // Animation automatique de démonstration (optionnelle)
  // ====================================

  // Décommenter pour activer une animation automatique
  /*
  let autoProgressInterval = setInterval(() => {
    if (currentProgress >= 100) {
      currentProgress = 0;
    } else {
      updateProgress(currentProgress + 1);
    }
  }, 100);

  // Arrêter l'animation automatique si l'utilisateur interagit
  [increaseBtn, decreaseBtn, resetBtn].forEach(btn => {
    btn.addEventListener('click', () => {
      clearInterval(autoProgressInterval);
    }, { once: true });
  });
  */

  // ====================================
  // Initialisation
  // ====================================
  function init() {
    // S'assurer que l'état initial est correct
    updateProgress(currentProgress);
  }

  // Lancer l'initialisation au chargement du DOM
  if (document.readyState === 'loading') {
    document.addEventListener('DOMContentLoaded', init);
  } else {
    init();
  }

})();
