// ====================================
// Bouton Animé Shake - Seed I.T
// ====================================

(function() {
  'use strict';

  // ====================================
  // Fonction : Ajouter l'effet shake
  // ====================================
  function addShakeEffect(button) {
    // Ajouter la classe d'animation
    button.classList.add('seedit-btn-shake--shaking');

    // Retirer la classe après l'animation (500ms)
    setTimeout(() => {
      button.classList.remove('seedit-btn-shake--shaking');
    }, 500);
  }

  // ====================================
  // Gestionnaires d'événements : Boutons avec shake au clic
  // ====================================
  const shakeClick1 = document.getElementById('shakeClick1');
  const shakeClick2 = document.getElementById('shakeClick2');

  if (shakeClick1) {
    shakeClick1.addEventListener('click', () => {
      addShakeEffect(shakeClick1);
    });

    // Accessibilité : gestion du clavier
    shakeClick1.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        addShakeEffect(shakeClick1);
      }
    });
  }

  if (shakeClick2) {
    shakeClick2.addEventListener('click', () => {
      addShakeEffect(shakeClick2);
    });

    // Accessibilité : gestion du clavier
    shakeClick2.addEventListener('keydown', (e) => {
      if (e.key === 'Enter' || e.key === ' ') {
        e.preventDefault();
        addShakeEffect(shakeClick2);
      }
    });
  }

  // ====================================
  // API publique (optionnelle)
  // ====================================
  // Permet d'ajouter l'effet shake programmatiquement sur n'importe quel bouton
  // Exemple d'utilisation :
  // const myButton = document.querySelector('#myCustomButton');
  // if (myButton) addShakeEffect(myButton);

  // Exporter la fonction dans un namespace Seed I.T (optionnel)
  window.SeeditShake = {
    shake: addShakeEffect
  };

  // ====================================
  // Exemple avancé : Shake automatique sur un événement
  // ====================================
  // Décommenter pour simuler un shake automatique toutes les 10 secondes
  /*
  const autoShakeButton = document.querySelector('.seedit-btn-shake--auto');
  if (autoShakeButton) {
    setInterval(() => {
      addShakeEffect(autoShakeButton);
    }, 10000);
  }
  */

})();
