// ========================================
// Seed I.T - Slider d'images automatique
// ========================================

(() => {
  'use strict';

  // Sélection des éléments du DOM
  const slider = document.querySelector('.seedit-slider');
  const slides = document.querySelectorAll('.seedit-slider__slide');
  const indicators = document.querySelectorAll('.seedit-slider__indicator');
  const btnPrev = document.querySelector('.seedit-slider__btn--prev');
  const btnNext = document.querySelector('.seedit-slider__btn--next');
  const btnControl = document.querySelector('.seedit-slider__control');
  const iconPause = document.querySelector('.seedit-slider__control-pause');
  const iconPlay = document.querySelector('.seedit-slider__control-play');

  // État du slider
  let currentIndex = 0;
  let autoPlayInterval = null;
  let isPlaying = true;
  const autoPlayDelay = 3000; // 3 secondes

  // Fonction pour afficher un slide spécifique
  function showSlide(index) {
    // Gérer le bouclage des slides
    if (index < 0) {
      currentIndex = slides.length - 1;
    } else if (index >= slides.length) {
      currentIndex = 0;
    } else {
      currentIndex = index;
    }

    // Retirer la classe active de tous les slides et indicateurs
    slides.forEach(slide => slide.classList.remove('seedit-slider__slide--active'));
    indicators.forEach(indicator => {
      indicator.classList.remove('seedit-slider__indicator--active');
      indicator.setAttribute('aria-selected', 'false');
    });

    // Ajouter la classe active au slide et indicateur courants
    slides[currentIndex].classList.add('seedit-slider__slide--active');
    indicators[currentIndex].classList.add('seedit-slider__indicator--active');
    indicators[currentIndex].setAttribute('aria-selected', 'true');

    // Annoncer le changement pour les lecteurs d'écran
    slider.setAttribute('aria-live', 'polite');
  }

  // Fonction pour passer au slide suivant
  function nextSlide() {
    showSlide(currentIndex + 1);
  }

  // Fonction pour passer au slide précédent
  function prevSlide() {
    showSlide(currentIndex - 1);
  }

  // Fonction pour démarrer le défilement automatique
  function startAutoPlay() {
    if (autoPlayInterval) return;

    autoPlayInterval = setInterval(nextSlide, autoPlayDelay);
    isPlaying = true;

    // Mise à jour de l'icône
    iconPause.style.display = 'block';
    iconPlay.style.display = 'none';
    btnControl.setAttribute('aria-label', 'Mettre en pause le défilement automatique');
  }

  // Fonction pour arrêter le défilement automatique
  function stopAutoPlay() {
    if (!autoPlayInterval) return;

    clearInterval(autoPlayInterval);
    autoPlayInterval = null;
    isPlaying = false;

    // Mise à jour de l'icône
    iconPause.style.display = 'none';
    iconPlay.style.display = 'block';
    btnControl.setAttribute('aria-label', 'Reprendre le défilement automatique');
  }

  // Fonction pour basculer Play/Pause
  function toggleAutoPlay() {
    if (isPlaying) {
      stopAutoPlay();
    } else {
      startAutoPlay();
    }
  }

  // Événements des boutons de navigation
  btnPrev.addEventListener('click', () => {
    prevSlide();
    stopAutoPlay(); // Arrêter l'autoplay lors d'une action manuelle
  });

  btnNext.addEventListener('click', () => {
    nextSlide();
    stopAutoPlay();
  });

  // Événements des indicateurs
  indicators.forEach((indicator, index) => {
    indicator.addEventListener('click', () => {
      showSlide(index);
      stopAutoPlay();
    });
  });

  // Événement du bouton Play/Pause
  btnControl.addEventListener('click', toggleAutoPlay);

  // Pause au survol du slider
  slider.addEventListener('mouseenter', stopAutoPlay);
  slider.addEventListener('mouseleave', () => {
    if (isPlaying) {
      startAutoPlay();
    }
  });

  // Navigation au clavier sur le conteneur principal
  slider.addEventListener('keydown', (e) => {
    switch(e.key) {
      case 'ArrowLeft':
        e.preventDefault();
        prevSlide();
        stopAutoPlay();
        break;
      case 'ArrowRight':
        e.preventDefault();
        nextSlide();
        stopAutoPlay();
        break;
      case ' ':
      case 'Enter':
        e.preventDefault();
        toggleAutoPlay();
        break;
    }
  });

  // Démarrer l'autoplay au chargement
  startAutoPlay();

  // Arrêter l'autoplay si l'onglet n'est pas visible (économie de ressources)
  document.addEventListener('visibilitychange', () => {
    if (document.hidden) {
      stopAutoPlay();
    } else if (isPlaying) {
      startAutoPlay();
    }
  });

})();
